//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

Rectangle {
    id : uiDropDownBg

    color : UiColors.getColor(UiColors.White)
    border {
        width : 1
        color : UiColors.getColor(UiColors.ControlGrey20)
    }
    opacity : 0

    UiColorizedImage {
        id : indicator

        anchors {
            right          : parent.right
            rightMargin    : 6
            verticalCenter : parent.verticalCenter
        }
        source : "qrc:/ui/images/dropdown-indicator.png"
        color  : "transparent"
    }

    states : [
        State {
            name : "disabled"
            when : !uiDropDownBg.enabled
        },
        State {
            name : "pressed"
            when : parent && parent.pressed

            PropertyChanges {
                target        : uiDropDownBg
                border.color  : UiColors.getColor(UiColors.SelectionGreen)
                opacity       : 1
            }
            PropertyChanges {
                target : indicator
                color  : UiColors.getColor(UiColors.SelectionGreen)
            }
        },
        State {
            name : "hover"
            when : parent && (parent.hovered || parent.activeFocus)

            PropertyChanges {
                target        : uiDropDownBg
                border.color  : UiColors.getColor(UiColors.HoverGreen)
                opacity       : 1
            }
            PropertyChanges {
                target  : indicator
                color   : UiColors.getColor(UiColors.HoverGreen)
            }
        }
    ]
}

